<?php
/*
 * Plugin Name: Africunia Bank Payment Gateway
 * Plugin URI: https://africuniabank.com/
 * Description: Make payment
 * Author: Sangram Singh Parihar
 * Author URI: 
 * Version: 1.0
 */


/*
 * This action hook registers our PHP class as a WooCommerce payment gateway
 */

include( plugin_dir_path( __FILE__ ) . 'Africunia/Api/Payment.php');
include( plugin_dir_path( __FILE__ ) . 'Africunia/Api/Amount.php');
include( plugin_dir_path( __FILE__ ) . 'Africunia/Api/Payer.php');

include( plugin_dir_path( __FILE__ ) . 'Africunia/Api/RedirectUrls.php');
include( plugin_dir_path( __FILE__ ) . 'Africunia/Api/Transaction.php');

add_filter( 'woocommerce_payment_gateways', 'africuniabank_add_gateway_class' );
function africuniabank_add_gateway_class( $gateways ) {
	$gateways[] = 'WC_AfricuniaBank_Gateway'; // your class name is here
	return $gateways;
}

add_action('admin_menu', 'custom_menu');

add_action( 'admin_post_africunia_form_response', 'africunia_form_response');

add_action('admin_post_submit-form', '_handle_form_action'); // If the user is logged in

add_action('admin_post_nopriv_submit-form', '_handle_form_action'); // If the user in not logged in

function custom_menu() 
{ 

		  add_menu_page( 
		      'Africunia Bank Payment Gateway', 
		      'Africunia Bank', 
		      'edit_posts', 
		      'africunia_bank_payment', 
		      'page_callback_function', 
		      'dashicons-media-spreadsheet' 

		     );
}

function page_callback_function()
{
	$abpg_enable = get_option('abpg_enable');
	$abpg_title = get_option('abpg_title');
	$abpg_description = get_option('abpg_description');
	$abpg_merchant = get_option('abpg_merchant');
	$abpg_secret = get_option('abpg_secret');
	$abpg_success_url = get_option('abpg_success_url');
	$abpg_cancel_url = get_option('abpg_cancel_url');
	include_once( 'admin_page.php' );
			
}


function africunia_form_response() {

		update_option( 'abpg_enable', $_POST['abpg_enable'] );
		update_option( 'abpg_title', $_POST['abpg_title'] );
		update_option( 'abpg_description', $_POST['abpg_description'] );
		update_option( 'abpg_merchant', $_POST['abpg_merchant'] );
		update_option( 'abpg_secret', $_POST['abpg_secret']);
		update_option( 'abpg_success_url', $_POST['abpg_success_url']);
		update_option( 'abpg_cancel_url', $_POST['abpg_cancel_url']);

		// do the processing

		// add the admin notice
		$admin_notice = "success";

		// redirect the user to the appropriate page
		 wp_redirect( $_SERVER['HTTP_REFERER']  );
		exit;			
	
}

function _handle_form_action(){
	$amount = $_POST['amount'];
	$abpg_merchant = get_option('abpg_merchant');
	$abpg_secret = get_option('abpg_secret');
	$abpg_success_url = get_option('abpg_success_url');
	$abpg_cancel_url = get_option('abpg_cancel_url');

	$payer = new Payer();
	$payer->setPaymentMethod('AFRICUNIA BANK Wallet');


	$amountIns = new Amount();
	$amountIns->setTotal($amount)->setCurrency('USD');

	//Transaction Object
	$trans = new Transaction();
	$trans->setAmount($amountIns);

	//RedirectUrls Object
	$urls = new RedirectUrls();
	$urls->setSuccessUrl($abpg_success_url) 
	->setCancelUrl($abpg_cancel_url); 

	//Payment Object
	$payment = new Payment();
	$payment->setCredentials([ //Client ID & Secret = Merchants->setting(gear icon)
	    'client_id'     => $abpg_merchant, //must provide correct client id of an express merchant
	    'client_secret' => $abpg_secret, //must provide correct client secret of an express merchant
	])
	->setRedirectUrls($urls)
	->setPayer($payer)
	->setTransaction($trans);

	try {
	    $payment->create(); //create payment
	    header("Location: " . $payment->getApprovedUrl()); //checkout url
	}
	catch (\Exception $ex)
	{
	    print $ex;
	    exit;
	}
}


function wpb_demo_shortcode($data) { 
$url = site_url( 'wp-content/plugins/africuniabank/logo.png' );
print_r($data);
$amount = $data['amount'];
$message = '<div class="col-6 col-md-4">
                                                <label class="aiz-megabox d-block mb-3">
                                                    
                                                    <span class="d-block p-3 aiz-megabox-elem">
                                                        <img src="'.$url.'" class="img-fluid mb-2">
                                                        <br />
                                                        <span class="d-block text-center">
                                                        <form action="'.get_admin_url().'admin-post.php" method="POST">
    <!-- your inputs -->
    <input type="hidden" name="action" value="submit-form"/>
    <input type="hidden" name="amount" value="'.$amount.'" />
    <input class="btn d-block fw-600 fs-15" type="submit" value="Pay with Africunia Bank"/>
</form>
                                                            
                                                            
                                                        </span>
                                                    </span>
                                                </label>
                                            </div>'; 
return $message;
} 



// register shortcode
add_shortcode('africunia_bank_payment_gateway', 'wpb_demo_shortcode'); 


